#ifndef LLF_ECPKI_KG_H
#define LLF_ECPKI_KG_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* for generation of new ECC key pairs, which worked with 
* LibTomCrypt. 
*
* \version LLF_ECPKI_KG.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_GenKeyPair
*
* Inputs:
* @param DomainID [in] - The enumerator variable defines the current EC domain;
* @param UserPrivKey_ptr [out] - A pointer to the output private key structure.
* @param UserPublKey_ptr [out] - A pointer to the otput public key structure.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  This function generate new key pair for ECC.
*
* \b 
* Algorithm:
*  -# Imports CE2 keys to LibTomCrypt format;
*  -# Create shared secret.
***************************************************************/
CE2Error_t LLF_ECPKI_GenKeyPair(
    CE2_ECPKI_DomainID_t  	    DomainID,	        /*in*/   
    CE2_ECPKI_UserPrivKey_t   *UserPrivKey_ptr,    /*out*/
    CE2_ECPKI_UserPublKey_t   *UserPublKey_ptr    /*out*/);

#ifdef __cplusplus
}
#endif

#endif /* LLF_ECPKI_KG_H */
